<!doctype html>
<html>
<head>
<?php
# If the request method is GET and 'Id' is specified in the request, turn on
# page auto-refresh so that job status updates will be seen as they arrive.
if ($_SERVER['REQUEST_METHOD'] == 'GET' && array_key_exists('Id', $_GET)) {
  echo "<meta http-equiv=\"refresh\" content=\"5\" />\n";
}
?>
</head>
<body>

<?php

require 'path/to/autoload.php';

use Aws\ElasticTranscoder\ElasticTranscoderClient;

$tmp_path = '/tmp';

# This will generate a 480p 16:9 mp4 output.
$preset_id = '1351620000001-000020';

# All inputs will have this prefix prepened to their input key.
$input_key_prefix = 'elastic-transcoder-samples/input/';

# All outputs will have this prefix prepended to their output key.
$output_key_prefix = 'elastic-transcoder-samples/output/';

# Region where you setup your AWS resources.
$region = 'us-east-1';

# Create the client for Elastic Transcoder.
$transcoder_client = ElasticTranscoderClient::factory(array('region' => $region, 'default_caching_config' => '/tmp'));

# This function will create an Elastic Transcoder job using the supplied elastic
# transcoder client, pipeline id, input key and output key prefix.  Output key
# is automatically set to SHA256(UTF8(<input-key>)).
function create_elastic_transcoder_job($transcoder_client, $pipeline_id, $input_key, $preset_id, $output_key_prefix) {
  # Setup the job input using the provided input key.
  $input = array('Key' => $input_key);
  
  # Setup the job output using the provided input key to generate an output key.
  $outputs = array(array('Key' => hash("sha256", utf8_encode($input_key)), 'PresetId' => $preset_id));
  
  # Create the job.
  $create_job_request = array(
        'PipelineId' => $pipeline_id,
        'Input' => $input,
        'Outputs' => $outputs,
        'OutputKeyPrefix' => $output_key_prefix
  );
  $create_job_result = $transcoder_client->createJob($create_job_request)->toArray();
  return $job = $create_job_result["Job"];
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
  # If the request method is POST, create a job using the posted data and save
  # the job information into the status file.
  try {
    $job = create_elastic_transcoder_job($transcoder_client, $_POST['pipelineid'], $_POST['inputkey'], $preset_id, $output_key_prefix);
    $status_file = "$tmp_path/{$job['Id']}";
    file_put_contents($status_file, json_encode($job, true) . "\n", FILE_APPEND | LOCK_EX);
    header("Location: JobStatusNotificationsSample.php?Id={$job['Id']}");
  } catch (Exception $e) {
    echo "Exception occurred: {$e->getMessage()}\n";
  }
} else if ($_SERVER['REQUEST_METHOD'] && array_key_exists('Id', $_GET)) {
  # If the request method is GET and 'Id' has been specified, then set the status file.
  $status_file = "$tmp_path/{$_GET['Id']}";
  if (is_file($status_file)) {
    echo '<pre>';
    echo file_get_contents($status_file);
    echo '</pre>';
  } else {
    echo "No job status file found.";
  }
} else if ($_SERVER['REQUEST_METHOD'] == 'GET'){
  # If the request method is GET and no 'Id' is specified, return the HTML form
  # which will allow the user to create an elastic transcoder job.
  echo "Create an Elastic Transcoder job and consume job status using notificaitons.<br><form action=\"http://ec2-23-22-149-62.compute-1.amazonaws.com/samples/JobStatusNotificationsSample.php\" method=\"POST\">Pipeline Id: <input name=\"pipelineid\" type=\"text\"/> (<a href=\"https://w.amazon.com/index.php/User:Ramsdenj/Samples/Environment_Setup/Create_Elastic_Transcoder_Pipeline#Create_the_Pipeline\"> Create an Elastic Transcoder Pipeline</a>)<br>Input key: <input name=\"inputkey\" type=\"text\" /><br><input type=\"submit\" value=\"Create Job\" /></form>";
}

?>
</body>
</html>

